<?php
/**
 * This file is part of the upgrade process.
 *
 * @package SendStudio
 */

/**
 * Do a sanity check to make sure the upgrade api has been included.
 */
if (!class_exists('Upgrade_API', false)) {
	exit;
}

/**
 * create_usergroups table
 *
 * @see Upgrade_API
 *
 * @package SendStudio
 */
class create_stats_newsletters_recipients extends Upgrade_API
{
	/**
	 * RunUpgrade
	 * @return Boolean Returns TRUE if successful, FALSE otherwise
	 */
	function RunUpgrade($upgrade=false)
	{
		if ($this->TableExists('stats_newsletters_recipients')) {
			return true;
		}

		
		$query = "CREATE TABLE " . SENDSTUDIO_TABLEPREFIX . "stats_newsletters_recipients (
				id int(11) NOT NULL AUTO_INCREMENT PRIMARY KEY,
				statid int(11) DEFAULT '0',
				newsletterid int(11) DEFAULT '0',
				send_status char(1) DEFAULT NULL,
				recipient int(11) DEFAULT '0',
				reason varchar(35) DEFAULT NULL,
				sendtime int(11) DEFAULT NULL  
			) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4";

	

		$result = $this->Db->Query($query);
		
		if ($result == false) {
			return false;
		}
		

		return true;
	}
}
