<?php
/**
* This file is part of the upgrade process.
*
* @author Imran Khan <imran.khan@interspire.com>
*
* @package SendStudio
*/

/**
* Do a sanity check to make sure the upgrade api has been included.
*/
if (!class_exists('Upgrade_API', false)) {
	exit;
}

/**
* This class runs one change for the upgrade process.
* The Upgrade_API looks for a RunUpgrade method to call.
* That should return false for failure
* It should return true for success or if the change has already been made.
*
* @package SendStudio
*/
class create_subscribers_data_subscriberid_fieldid_index extends Upgrade_API
{
	/**
	 * RunUpgrde
	 * Run current upgrade
	 * @return Boolean Returns TRUE if successful, FALSE otherwise
	 */
	public function RunUpgrade($upgrade = false)
	{  
		// If index subscribers_data_data_idx has not exists create, go to next
		if (!$this->IndexExists('subscribers_data', ['data'])) {
			$status1 = $this->Db->Query("CREATE INDEX " . SENDSTUDIO_TABLEPREFIX . "subscribers_data_data_idx	 on " . SENDSTUDIO_TABLEPREFIX . "subscribers_data(data (255))"); 
		}

		// If index subscribers_data_field_subscriber_idx has not exists create, go to next
		if (!$this->IndexExists('subscribers_data', ['fieldid'])) {
			$status2 = $this->Db->Query("CREATE INDEX " . SENDSTUDIO_TABLEPREFIX . "subscribers_data_field_subscriber_idx on " . SENDSTUDIO_TABLEPREFIX . "subscribers_data(fieldid, subscriberid)");
		}

		// for UNIQUE  is true If index subscribers_data_subscriber_field_idx has not exists create, go to next
		if (!$this->IndexExists('subscribers_data', ['subscriberid'],true,'BTREE')) {
			$status3 = $this->Db->Query("CREATE UNIQUE INDEX " . SENDSTUDIO_TABLEPREFIX . "subscribers_data_subscriber_field_idx on " . SENDSTUDIO_TABLEPREFIX . "subscribers_data(subscriberid, fieldid)");		  
		}
      
		return true;
	}
}