/**
 * jQuery.ScrollTo - Easy element scrolling using jQuery.
 * Copyright (c) 2008 Ariel Flesler - aflesler(at)gmail(dot)com | http://flesler.blogspot.com
 * Dual licensed under the MIT (http://www.opensource.org/licenses/mit-license.php)
 * and GPL (http://www.opensource.org/licenses/gpl-license.php) licenses.
 * Date: 2/19/2008
 * @author Ariel Flesler
 * @version 1.3.3
 */
(function ($) {
  var o = ($.scrollTo = function (a, b, c) {
    o.window().scrollTo(a, b, c);
  });
  o.defaults = { axis: "y", duration: 1 };
  o.window = function () {
    return $($.browser.safari ? "body" : "html");
  };
  $.fn.scrollTo = function (l, m, n) {
    if (typeof m == "object") {
      n = m;
      m = 0;
    }
    n = $.extend({}, o.defaults, n);
    m = m || n.speed || n.duration;
    n.queue = n.queue && n.axis.length > 1;
    if (n.queue) m /= 2;
    n.offset = j(n.offset);
    n.over = j(n.over);
    return this.each(function () {
      var a = this,
        b = $(a),
        t = l,
        c,
        d = {},
        w = b.is("html,body");
      switch (typeof t) {
        case "number":
        case "string":
          if (/^([+-]=)?\d+(px)?$/.test(t)) {
            t = j(t);
            break;
          }
          t = $(t, this);
        case "object":
          if (t.is || t.style) c = (t = $(t)).offset();
      }
      $.each(n.axis.split(""), function (i, f) {
        var P = f == "x" ? "Left" : "Top",
          p = P.toLowerCase(),
          k = "scroll" + P,
          e = a[k],
          D = f == "x" ? "Width" : "Height";
        if (c) {
          d[k] = c[p] + (w ? 0 : e - b.offset()[p]);
          if (n.margin) {
            d[k] -= parseInt(t.css("margin" + P)) || 0;
            d[k] -= parseInt(t.css("border" + P + "Width")) || 0;
          }
          d[k] += n.offset[p] || 0;
          if (n.over[p]) d[k] += t[D.toLowerCase()]() * n.over[p];
        } else d[k] = t[p];
        if (/^\d+$/.test(d[k])) d[k] = d[k] <= 0 ? 0 : Math.min(d[k], h(D));
        if (!i && n.queue) {
          if (e != d[k]) g(n.onAfterFirst);
          delete d[k];
        }
      });
      g(n.onAfter);
      function g(a) {
        b.animate(
          d,
          m,
          n.easing,
          a &&
            function () {
              a.call(this, l);
            }
        );
      }
      function h(D) {
        var b = w
          ? $.browser.opera
            ? document.body
            : document.documentElement
          : a;
        return b["scroll" + D] - b["client" + D];
      }
    });
  };
  function j(a) {
    return typeof a == "object" ? a : { top: a, left: a };
  }
})(jQuery);

$(document).ready(function () {
  jQuery.fn.exists = function () {
    return this.is("*");
  };
});

$(document).ready(function () {
  jQuery.fn.length = function () {
    return this.length;
  };
});

$(document).ready(function () {
  jQuery.fn.errorMessage = function (error, arrMsgs) {
    var val = "";

    if (arrMsgs && arrMsgs.length > 0) {
      val = error + "<ul>";
      for (i = 0; i < arrMsgs.length; i++) {
        val += "<li>" + arrMsgs[i] + "</li>";
      }
      val += "</ul>";
    } else {
      val = error;
    }
    // Copy of templates/errormsg.tpl
    $(this).html(
      `
				<div class="border-l-4 border-red-400 rounded-md bg-red-50 p-4 mb-2">
				<div class="flex items-center">
				  <div class="flex-shrink-0 h-5 w-5 text-red-400">
					<svg class="fill-red-400" viewBox="0 0 20 20" fill="currentColor" aria-hidden="true">
						<path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.28 7.22a.75.75 0 00-1.06 1.06L8.94 10l-1.72 1.72a.75.75 0 101.06 1.06L10 11.06l1.72 1.72a.75.75 0 101.06-1.06L11.06 10l1.72-1.72a.75.75 0 00-1.06-1.06L10 8.94 8.28 7.22z" clip-rule="evenodd" />
					</svg>
				  </div>
				  <div class="ml-3">
						<h3 class="text-sm font-medium text-red-800">` +
        error +
        `</h3>
				  </div>
				</div>
				</div>`
    );
    if ($(this).css("display") == "none") {
      $(this).show("slow");
    }
  };
});

$(document).ready(function () {
  jQuery.fn.successMessage = function (msg) {
    // Copy of templates/successmsg.tpl
    $(this).html(
      `
				<div class="w-auto border-l-4 border-green-400 rounded-md bg-green-50 p-4">
				<div class="flex items-center">
				<div class="flex-shrink-0 h-5 w-5 text-green-400">
					<svg viewBox="0 0 20 20" fill="currentColor" aria-hidden="true">
						<path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.857-9.809a.75.75 0 00-1.214-.882l-3.483 4.79-1.88-1.88a.75.75 0 10-1.06 1.061l2.5 2.5a.75.75 0 001.137-.089l4-5.5z" clip-rule="evenodd" />
					</svg>
				</div>
				<div class="ml-3">
						<h3 class="text-sm font-medium text-green-800">` +
        msg +
        `</h3>
				</div>
				</div>
				</div>`
    );
    if ($(this).css("display") == "none") {
      $(this).show("slow");
    }
  };
});

$(document).ready(function () {
  jQuery.fn.infoMessage = function (msg, animate) {
    if (typeof animate == "undefined") var animate = true;
    // Copy of templates/warningmsg.tpl
    $(this).html(
      `
				<div class="border-l-4 border-yellow-400 rounded-md bg-yellow-50 p-4">
				<div class="flex items-center">
				<div class="flex-shrink-0">
					<svg class="h-5 w-5 text-yellow-400" viewBox="0 0 20 20" fill="currentColor" aria-hidden="true">
						<path fill-rule="evenodd" d="M8.485 2.495c.673-1.167 2.357-1.167 3.03 0l6.28 10.875c.673 1.167-.17 2.625-1.516 2.625H3.72c-1.347 0-2.189-1.458-1.515-2.625L8.485 2.495zM10 5a.75.75 0 01.75.75v3.5a.75.75 0 01-1.5 0v-3.5A.75.75 0 0110 5zm0 9a1 1 0 100-2 1 1 0 000 2z" clip-rule="evenodd" />
					</svg>
				</div>
				<div class="ml-3">
						<h3 class="text-sm font-medium text-yellow-800">` +
        msg +
        `</h3>
				</div>
				</div>
			</div>`
    );
    if ($(this).css("display") == "none") {
      $(this).show(animate ? "slow" : null);
    }
  };
});

$(document).ready(function() {
	jQuery.fn.warningMessage = function(msg) {

			$(this).html('<div class="border-l-4 border-yellow-400 rounded-md bg-yellow-50 p-4 mb-2"><div class="flex items-center"><div class="flex-shrink-0"><img src="images/warning.gif" width="18" height="18" hspace="10" alt="error" class="m-0" /></div><div class="ml-3"><h3 class="text-sm font-medium text-yellow-800">'+msg+'</h3></div></div></div>');
			if($(this).css('display') == 'none'){
				$(this).show('slow');
			}
		}
});

(function ($) {
  $.evalJSON = function (
    src // Evals JSON that we know to be safe.
  ) {
    eval("var json = " + src + ";");
    return json;
  };
})(jQuery);
