<?php
require_once('vendor/autoload.php'); 
use Webklex\PHPIMAP\ClientManager;
use Webklex\PHPIMAP\Client;

// Make sure that the IEM controller does NOT redirect request.
if (!defined('IEM_NO_CONTROLLER')) {
	define('IEM_NO_CONTROLLER', true);
}

// Displaying an archive does not need a session to be started.
if (!defined('IEM_NO_SESSION')) {
	define('IEM_NO_SESSION', true);
}

// Require base sendstudio functionality. This connects to the database, sets up our base paths and so on.
require_once dirname(__FILE__) . '/admin/index.php';

if (SENDSTUDIO_IS_SETUP != 1) {
	exit;
}

/**
* This file lets us get api's, load language files and parse templates.
*/
require_once(SENDSTUDIO_FUNCTION_DIRECTORY . '/sendstudio_functions.php');

$sendstudio_functions = new Sendstudio_Functions();
 
 
// Create a new Google_Client instance
 
// If the user is not authenticated, redirect them to Google's authentication page
if (!isset($_GET['code'])) {
   // echo "No code found";exit;
    $authURL = $client->createAuthUrl();
	echo $authURL;exit;
    header('Location: ' . filter_var($authURL, FILTER_SANITIZE_URL));
} else {
	$client = new Google_Client();
		
	$listsApi = $sendstudio_functions->GetApi('Lists');
	$clientID = $listsApi->getListClientIDTempdata();
	$clientSecret = $listsApi->getListClientSecretTempdata();
	$redirectURI = SENDSTUDIO_APPLICATION_URL.'/oauth2callbacklist.php';
	$client->setClientId($clientID);
	$client->setClientSecret($clientSecret);
	$client->setRedirectUri($redirectURI);
	$accessToken = $client->fetchAccessTokenWithAuthCode($_GET['code']);
	$client->setAccessType('offline'); // Allow offline access to refresh token
	$client->setPrompt('consent');
	$client->addScope('https://mail.google.com/');
      
	if(isset($accessToken['error']) && !empty($accessToken['error'])) {
		//print_r($accessToken);
		//echo $accessToken['error'];
		$GLOBALS['Error'] = $accessToken['error'].' : '.$accessToken['error_description'];
		$sendstudio_functions->ParseTemplate('error_google_oauth', false, true, '');
		exit;
	}

	$client->setAccessToken($accessToken);
	$access_token = $accessToken['access_token']; // this token is used in the below code.
	if (isset($accessToken['refresh_token'])) {
		$refreshToken = $accessToken['refresh_token'];
		//re set values in json file Client id and secret id

		//$settingApi = new   Settings_API();
		
		$listsApi->saveRefreshTokenTempdata($refreshToken,$clientID);
		?>
		<script>  
		window.opener.document.getElementById('setting_submit').disabled = true; 
		window.opener.document.getElementById('bounce_process').innerHTML= '<option value="a" selected>Google Account Authenticated</option>';		
		window.opener.focus(); 
		window.close();	
		</script>
		
		<?php
	  
     	// header('Location:admin/index.php?Page=lists&Action=create');
   }else{
        //header('Location:admin/index.php?Page=lists&Action=create&clientID='.$clientID.'&tokenStatus=1&clientSecret='.$clientSecret.'');
   }
    
}
	//config json client_credentials 
?>
