<?php

class Interspire_Validator_NumberRange extends Interspire_Validator_Abstract
{
	/**
	 * @var Int $startRange
	 */
	public $startRange;

	/**
	 * @var Int $endRange
	 */
	public $endRange;
	
	/**
	 * @param Int $startRange
	 * @param Int $endRange
	 * 
	 * @return Void
	 */
	public function __construct($startRange = 0, $endRange = 0)
	{
		$this->startRange = $startRange;
		$this->endRange   = $endRange;
	}
	
	/**
	 * @return Bool
	 */
	public function isValid()
	{
		$this->value = (int) $this->value;
		
		if ($this->value >= $this->startRange) {
			if ($this->endRange && $this->value > $this->endRange) {
				return false;
			}
			
			return true;
		}
		
		return false;
	}
}