<?php
/**
* This file is part of the upgrade process.
*
* @author Imran Khan <imran.khan@interspire.com>
*
* @package SendStudio
*/

/**
* Do a sanity check to make sure the upgrade api has been included.
*/
if (!class_exists('Upgrade_API', false)) {
	exit;
}

/**
* This class runs one change for the upgrade process.
* The Upgrade_API looks for a RunUpgrade method to call.
* That should return false for failure
* It should return true for success or if the change has already been made.
*
* @package SendStudio
*/
class update_stats_emailopens_openip extends Upgrade_API
{
	/**
	 * RunUpgrde
	 * Run current upgrade
	 * @return Bool Returns TRUE if successful, FALSE otherwise
	 */

	function RunUpgrade($upgrade=false)
	{
        $status = $this->Db->Query('ALTER TABLE  ' . SENDSTUDIO_TABLEPREFIX . 'stats_emailopens CHANGE openip openip VARCHAR(45)');
		if ($status === false) {
			return false;
		}

		return true;
	}
}