<?php
/**
 * This file adds the subscriber_id column to the surveys_response table
 *
 * @author Imran Khan <imran.khan@interspire.com>
 *
 * @package SendStudio
 * @subpackage Language
 */

/**
 * Make sure the upgrade system has been included.
 */
if (!class_exists('Upgrade_API', false)) {
	exit();
}

/**
 * Add the enableunlayer column to the users table
 *
 * @see Upgrade_API
 *
 * @package SendStudio
 * @subpackage Upgrades
 */
class surveys_response_add_subscriber_id_column extends Upgrade_API
{
	/**
	 * RunUpgrade
	 * Runs the add_subscriber_id_column upgrade process.
	 *
	 * @param Mixed $upgrade Details about the upgrade process.
	 *
	 * @return boolean Returns true if the upgrade was successful, otherwise returns false.
	 */
	function RunUpgrade($upgrade = false)
	{
		// If the table doesn't exist, we don't need to do anything
		if (!$this->TableExists('surveys_response')) {
			return true;
		}

		// If the column already exists, we don't need to do anything
		if ($this->ColumnExists('surveys_response', 'subscriber_id')) {
			return true;
		}
		
		// Add the subscriber_id column after surveys_id
		$query = "ALTER TABLE " . SENDSTUDIO_TABLEPREFIX . "surveys_response ADD COLUMN subscriber_id INT(11) DEFAULT NULL AFTER `surveys_id`";
		$result = $this->Db->Query($query);
		
		if (!$result) {
			return false;
		}
		
		return true;
	}
} 