<?php
/**
* This file handles displaying latest newsletter of a contact list.
*
* display-last.php
* @author Imran Khan <imran.khan@interspire.com>
*
* @package SendStudio
*/

// Make sure that the IEM controller does NOT redirect request.
if (!defined('IEM_NO_CONTROLLER')) {
	define('IEM_NO_CONTROLLER', true);
}

// Displaying an archive does not need a session to be started.
if (!defined('IEM_NO_SESSION')) {
	define('IEM_NO_SESSION', true);
}

// Require base sendstudio functionality. This connects to the database, sets up our base paths and so on.
require_once dirname(__FILE__) . '/admin/index.php';

if (SENDSTUDIO_IS_SETUP != 1) {
	exit;
}

/**
* This file lets us get api's, load language files and parse templates.
*/
require_once(SENDSTUDIO_FUNCTION_DIRECTORY . '/sendstudio_functions.php');

$sendstudio_functions = new Sendstudio_Functions();

$listapi = $sendstudio_functions->GetApi('Lists');

$listid = 0;
if (isset($_GET['List'])) {
	$listid = (int)$_GET['List'];
} else {
	if (isset($_GET['L'])) {
		$listid = (int)$_GET['L'];
	}
}

if (!$listid){
	echo 'Invalid link.';
	exit();
}
$list_loaded = $listapi->Load($listid);

if (!$list_loaded) {
	echo 'Invalid link.';
	exit();
}

$last_newsletter = $listapi->GetLastNewsletter($listid); 

/**
* Since we're displaying a specific newsletter we can check for the list before anything else.
* If it's not valid, we can abort.
*/
if($last_newsletter['newsletterid'] <= 0 ) {
	echo "No Newsletter Found";
}


$format = $last_newsletter['format'];
if ($format == 't') {
	$description = nl2br($last_newsletter['textbody']);
} else {
	$description = $last_newsletter['htmlbody'];
}

header('Content-type: text/html; charset=UTF-8');
echo $description;
